//
//  Identity.h
//  Keychain
//
//  Created by Wade Tregaskis on Fri Jan 24 2003.
//  Copyright (c) 2003 Wade Tregaskis. All rights reserved.
//

#import "NSCachedObject.h"
#import <Foundation/Foundation.h>
#import <Security/Security.h>
#import "Certificate.h"
#import "Key.h"


@interface Identity : NSCachedObject {
    SecIdentityRef identity;
    int error;
}

+ (Identity*)identityWithIdentityRef:(SecIdentityRef)ident;

- (Identity*)initWithIdentityRef:(SecIdentityRef)ident;

- (Certificate*)certificate;
- (Key*)key;

- (int)lastError;
- (SecIdentityRef)identityRef;

@end
